<?php

header("Content-type: application/json; charset=utf-8");

if (isset($_SERVER['HTTP_ORIGIN'])) {
    // Decide if the origin in $_SERVER['HTTP_ORIGIN'] is one
    // you want to allow, and if so:
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 1000');
}
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
        // may also be using PUT, PATCH, HEAD etc
        header("Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE");
    }

    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
        header("Access-Control-Allow-Headers: Accept, Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token, Authorization");
    }
    exit(0);
}

include '../utils/database.php';
include '../utils/helper.php';

$typeFirst = $_POST['type'];
$aidFirst = $_POST['aid'];
$codeFirst = $_POST['code'];
$textFirst = $_POST['text'];
if (sizeof($_POST) == 0){
    $typeFirst = $_GET['type'];
    $aidFirst = $_GET['aid'];
    $codeFirst = $_GET['code'];
    $textFirst = $_GET['text'];
}


$currentTime = time();

$token = null;
$headers = apache_request_headers();
$language = getLanguageFromHeader($headers);

$type = convertPersianToEnglish($typeFirst);


if ($type == "eghdam" or $type == "eghdamAd" or $type == "desire" or $type == "Preg" or $type == "prevent" or $type == "PageFitness" or $type == "ovary" or $type == "eghdamA"){

}

else{

    header("HTTP/1.0 404 Not Found");
    die();
}

$aid = convertPersianToEnglish($aidFirst);
$aidList = $aid;
$aidListString = $aid;
$code = convertPersianToEnglish($codeFirst);
$qid = null;

$persona = getPersonaFromType($type);

$conn = new mysqli($servername, $username, $password, $dbname_process);
mysqli_set_charset($conn, "utf8");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}


if(isset($headers['Authorization']) and strlen($headers['Authorization']) > 5){
    $token = $headers['Authorization'];
}
else {
    if (isset($_GET['Authorization']) and strlen($_GET['Authorization']) > 5){
        $token = $_GET['Authorization'];
    }
    else{
        $token = md5(uniqid(rand(), true)).md5(uniqid(rand(), true)).md5(uniqid(rand(), true));
        $conn->query("INSERT INTO users(token , persona , created_at)VALUES('$token' , '$persona' , '$currentTime')");
    }

}

$image = "https://www.mintapp.ir/wp-content/uploads/2020/08/woman-687560_1280.jpg";
$video = "https://file.mintapp.ir/jadde/varzesh.mp4";
$diagramData = array(
//    array("label"=>"sat" , "open"=>"1201" , "high"=>"1245" , "low"=>"1187" , "close"=>"1235"),
//    array("label"=>"sun" , "open"=>"1235" , "high"=>"1375" , "low"=>"1135" , "close"=>"1353"),
//    array("label"=>"mon" , "open"=>"1353" , "high"=>"1381" , "low"=>"1087" , "close"=>"1103"),
//    array("label"=>"tue" , "open"=>"1103" , "high"=>"1245" , "low"=>"1187" , "close"=>"997"),
//    array("label"=>"wed" , "open"=>"997" , "high"=>"1045" , "low"=>"956" , "close"=>"993"),
//    array("label"=>"thu" , "open"=>"993" , "high"=>"1245" , "low"=>"1187" , "close"=>"1135"),
//    array("label"=>"fri" , "open"=>"1135" , "high"=>"1245" , "low"=>"1087" , "close"=>"1231"),
);
$diagram = array(
    "type"=>"candle"  ,
    "data"=>$diagramData
);

$diagram = "";


$text = "";
$code = "";

$title = "";

$isResult = "false";

$dialogTitle = "";
$dialogDescription = "";

$questionType = "singleSelect";
$answers = array();

if (strlen($codeFirst) > 5){
    $code = $codeFirst;
}

if (strlen($textFirst) > 5){
    $text = $textFirst;
}

$resultsIds = array("PagePayment" , "PageFreeMenu" , "PageBabyCheck" , "PageDischarge" , "PageForget" , "PageContraception" , "PageBestWay" , "PagePMS" , "PageEmergency" , "PageDelay");

$query = null;
if ($aid == "start"){
    if ($type == "eghdamAd"){
        $code = generateCode(16);
        $code = $code . "AAD";
    }
    else {
        $code = generateCode(16);
    }

    $query = "SELECT * FROM questions WHERE `type`='$type' ORDER BY id LIMIT 1";
    $result = $conn->query($query);
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $qid = $row["qid"];
            if ($type == "eghdam"){
                error_log("answered: " . $qid . " at time: " . time() . PHP_EOL, 3, "eghdamLog/".$qid.".log");
            }
        }
    }
}
else {
    if (strpos($aid , ',')){
        $aidList = explode("," , $aid);
        $aid = $aidList[0];
    }
    $query_a = "SELECT * FROM answers WHERE `aid`='$aid' AND `type`='$type'";
    $resultAnswer = $conn->query($query_a);
    if ($resultAnswer->num_rows > 0) {
        while($rowAnswer = $resultAnswer->fetch_assoc()) {
            $qid_next = $rowAnswer["next_question"];
            $qid = $rowAnswer["qid"];
            if ($type == "eghdam"){
                error_log("answered: " . $qid . " at time: " . time() . PHP_EOL, 3, "eghdamLog/".$qid.".log");
            }
            $query = "SELECT * FROM questions WHERE `type`='$type' AND `qid`='$qid_next'";
        }
    }
}

if ($query == null){
    error_log("query is null: " . time() . " post: " . $_POST . " get: " . $_GET . PHP_EOL, 3, "./queryError.log");
}

if ($conn->query("INSERT INTO process(`token` , `code` , `type` , `qid` , `aid` , `text_box` , `created_at`) VALUES ('$token' , '$code' , '$type' , '$qid' , '$aidListString' , '$text' , '$currentTime')")) {
    $res = null;


    $result = $conn->query($query);
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $questionType = $row["questionType"];
            $qid = $row["qid"];
            $query_a = "SELECT * FROM answers WHERE `qid`='$qid' AND `type`='$type'";
            $result_a = $conn->query($query_a);
            if ($result_a->num_rows > 0) {
                while($row_a = $result_a->fetch_assoc()) {
                    $res_in["aid"] = $row_a["aid"];
                    $res_in["text"] = $row_a['text'];
                    $isResult = $row_a["is_result"];
                    array_push($answers , $res_in);
                }
            }

            $res['token'] = $token;
            $res['code'] = $code;
            $res['title'] = $title;
            $res['dialogTitle'] = $dialogTitle;
            $res['dialogDescription'] = $dialogDescription;
            $res['forceDialog'] = "false";
            $res['qid'] = $row['qid'];
            $res['type'] = $row['type'];
            $res['questionType'] = $questionType;
            $res['video'] = $row['video'];
            $res['image'] = "";
            $res['diagram'] = $diagram;
            $res['text'] = $row['text'];
            $hint = $row['hint'];
            if (strlen($hint) < 5){
                $hint = "";
            }
            $res['hint'] = $hint;
            $res["isResult"] = (string)$isResult;
            $res['answers'] = $answers;

        }
    }

    $response['success'] = 'true';
    $response['message'] = '200';
    $response['result'] = $res;
    $json_response = json_encode($response);
    echo $json_response;
    die();
}
else {
    $response['success'] = 'false';
    $response['message'] = 'مشکل در ذخیره سازی اطلاعات';
    $json_response = json_encode($response);
    echo $json_response;
    die();
}

$conn->close();
