<?php
header('Access-Control-Allow-Origin: *');
header("Content-type: application/json; charset=utf-8");

if (isset($_SERVER['HTTP_ORIGIN'])) {
  // Decide if the origin in $_SERVER['HTTP_ORIGIN'] is one
  // you want to allow, and if so:
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Credentials: true');
  header('Access-Control-Max-Age: 1000');
}
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
  if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
    // may also be using PUT, PATCH, HEAD etc
    header("Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE");
  }

  if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
    header("Access-Control-Allow-Headers: Accept, Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token, Authorization");
  }
  exit(0);
}

include '../../utils/database.php';
include '../../utils/helper.php';

$conn = new mysqli($servername, $username, $password, $dbname_process);
mysqli_set_charset($conn, "utf8");
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$mainObj = array();

$result = $conn->query("SELECT * FROM questionsV2_json WHERE `type`='fit'");
if ($result->num_rows > 0) {
  while ($row = $result->fetch_assoc()) {
    $qid = $row["qid"];
    $mainObj[$qid] = [
      'qid' => $qid,
      'questionStyle' => $row['questionStyle'],
      'styles' => array(
        'backgroundColor'=>'green',
        'color' => 'white',
      ),
    ];
  }
}

echo json_encode($mainObj, JSON_UNESCAPED_UNICODE);
