<?php

require_once 'jdf.php';

function checkTransactionStatus($phoneNumber, $project)
{

    $planId = "404";
    $status = "404";

    $url = 'https://nikaatmint.ir/api/v1/checkTransaction.php?phoneNumber=' . $phoneNumber . '&project=' . $project;

    $response = file_get_contents($url);


    $data = json_decode($response, true);

    if (isset($data['data'])) {
        $planId = $data['data']['planId'];
    }

    if ($planId != "404") {
        $status = $planId;
        if (strpos($planId, "vip") !== false) {
            $status = "vip";
        }
    }

    return $status;
}

function savePostData($fileName)
{
    file_put_contents($fileName . ".log", print_r($_POST, true));
}

function getTextFromId($tid, $language)
{
    include "database.php";
    $text = "";
    $conn = new mysqli($servername, $username, $password, $dbname_process);
    mysqli_set_charset($conn, "utf8");
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    $result_text = $conn->query("SELECT * FROM translate WHERE `tid`='$tid'");
    if ($result_text->num_rows > 0) {
        while ($row_text = $result_text->fetch_assoc()) {
            $text = $row_text[$language];
        }
    }
    return $text;
}

function bodyFatPercentage($gender = "female", $BMI = 25, $age = 25)
{
    //$ratio = 5.4;
    //if ($gender != "female") {
    //  $ratio = 16.2;
    //}
    //$result = (1.20 * $BMI) + (0.23 * $age) - $ratio;
    //return round($result);

    $genderValue = 0;
    if ($gender == "male") {
        $genderValue = 1;
    }
    $bodyFatPercentage = (1.29 * $BMI) + (0.20 * $age) - (11.4 * $genderValue) - 8.0;
    $bodyFatPercentage = round($bodyFatPercentage);

    return $bodyFatPercentage;
}

function getSymbolFromCurrency($currency)
{
    $symbol = "$";
    switch ($currency) {
        case "EUR":
            return "€";
        case "USD":
            return "$";
        case "GBP":
            return "£";
    }
    return $symbol;
}

function convertFootToCm($input)
{
    return round($input * 30.48);
}
function convertCmToFoot($input)
{
    return round($input / 30.48);
}
function convertKgToLbs($input)
{
    return round($input * 2.20462);
}
function convertLbsToKg($input)
{
    return round($input / 2.20462);
}

function getCurrencyFromIP($userIp)
{
    $currency = "IRT";
    $validIPs = array("USD", "EUR", "GBP", "AUD", "CAD", "AED", "INR");
    //$userIp = getUserIpAddr();
    // $url = 'https://apiip.net/api/check?ip=' . $userIp . '&accessKey=b44439aa-7703-457e-b209-4a6cc35c5edd';
    // $ch = curl_init($url);
    // curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
    // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // $result = curl_exec($ch);
    // curl_close($ch);
    // $response = json_decode($result, true);
    // $currency = $response["currency"]["code"];
    // if (!in_array($currency, $validIPs)) {
    //     $currency = "USD";
    // }
    return $currency;
}

function monthNumberToMonthName($monthNumber, $language = "fa", $short = "false")
{
    if ($monthNumber > 12) {
        $monthNumber = $monthNumber - 12;
    }
    switch ($monthNumber) {
        case "01":
            return "فروردین";
            break;
        case "02":
            return "اردیبهشت";
            break;
        case "03":
            return "خرداد";
            break;
        case "04":
            return "تیر";
            break;
        case "05":
            return "مرداد";
            break;
        case "06":
            return "شهریور";
            break;
        case "07":
            return "مهر";
            break;
        case "08":
            return "آبان";
            break;
        case "09":
            return "آذر";
            break;
        case "10":
            return "دی";
            break;
        case "11":
            return "بهمن";
            break;
        case "12":
            return "اسفند";
            break;
        case "1":
            return "فروردین";
            break;
        case "2":
            return "اردیبهشت";
            break;
        case "3":
            return "خرداد";
            break;
        case "4":
            return "تیر";
            break;
        case "5":
            return "مرداد";
            break;
        case "6":
            return "شهریور";
            break;
        case "7":
            return "مهر";
            break;
        case "8":
            return "آبان";
            break;
        case "9":
            return "آذر";
            break;
    }
}

function showErrors()
{
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
}

function getPersonaFromType($type)
{
    $persona = "null";
    switch ($type) {
        case "inc":
            $persona = "inc";
            break;
        case "gym":
            $persona = "gym";
            break;
        case "fit":
            $persona = "fit";
            break;
        case "fastfit":
            $persona = "fastfit";
            break;
        case "ovary":
            $persona = "ovary";
            break;
        case "desire":
            $persona = "desire";
            break;
        case "prevent":
            $persona = "prevent";
            break;
        case "type1":
            $persona = "prepregnant";
            break;
        case "eghdam":
            $persona = "prepregnant";
            break;
        case "eghdamAd":
            $persona = "prepregnant";
            break;
        case "Preg":
            $persona = "pregnant";
            break;
        case "PageFitness":
            $persona = "fitness";
            break;
        case "PageBabyCheck":
            $persona = "prevent";
            break;
        case "PageRelievingMenstrualSymptoms":
            $persona = "prevent";
            break;
        case "PageBestContraception":
            $persona = "prevent";
            break;
        case "PageContraception":
            $persona = "prevent";
            break;
        case "PageEmergencyPill":
            $persona = "prevent";
            break;
        case "PageRetardationOfMenstrual":
            $persona = "prevent";
            break;
        case "PageTreatmentOfVaginalDischarge":
            $persona = "prevent";
            break;
    }
    return $persona;
}

function getTextFromTid($tid, $language)
{
    include "database.php";
    $text = "";
    $conn = new mysqli($servername, $username, $password, $dbname_process);
    mysqli_set_charset($conn, "utf8");
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    $result_text = $conn->query("SELECT * FROM texts WHERE `tid`='$tid' AND `language`='$language'");
    if ($result_text->num_rows > 0) {
        while ($row_text = $result_text->fetch_assoc()) {
            $text = $row_text["text"];
        }
    }
    return $text;
}

function detectYear($year, $month, $day, $language)
{
    if ($language == "fa") {
        return (string) $year;
    } else {
        $miladi = jalali_to_gregorian($year, $month, $day);
        return (string) $miladi[0];
    }
}
function detectMonth($year, $month, $day, $language)
{
    if ($language == "fa") {
        return (string) $month;
    } else {
        $miladi = jalali_to_gregorian($year, $month, $day);
        return (string) $miladi[1];
    }
}
function detectDay($year, $month, $day, $language)
{
    if ($language == "fa") {
        return (string) $day;
    } else {
        $miladi = jalali_to_gregorian($year, $month, $day);
        return (string) $miladi[2];
    }
}

function getLanguageFromHeader($headers)
{
    $language = "fa";
    if (isset($headers['language'])) {
        $language = $headers['language'];
    }
    return $language;
}

function miladiToShamsiYear($year, $month, $day)
{
    $shamsi = gregorian_to_jalali($year, $month, $day);
    return (string) $shamsi[0];
}

function miladiToShamsiMonth($year, $month, $day)
{
    $shamsi = gregorian_to_jalali($year, $month, $day);
    return (string) $shamsi[1];
}

function miladiToShamsiDay($year, $month, $day)
{
    $shamsi = gregorian_to_jalali($year, $month, $day);
    return (string) $shamsi[2];
}

function shamsiToMiladiYear($year, $month, $day)
{
    $miladi = jalali_to_gregorian($year, $month, $day);
    return (string) $miladi[0];
}

function shamsiToMiladiMonth($year, $month, $day)
{
    $miladi = jalali_to_gregorian($year, $month, $day);
    return (string) $miladi[1];
}

function shamsiToMiladiDay($year, $month, $day)
{
    $miladi = jalali_to_gregorian($year, $month, $day);
    return (string) $miladi[2];
}

function sendNotif($title, $description, $ids)
{

    $url = 'https://fcm.googleapis.com/fcm/send';
    $serverToken = "AAAA6kp-qUY:APA91bE7TvNf3RBYtWghoMAyccUbhYrV-Cbz8TsuWg5c0UaN3VcbHIxGQVHV4ZNS11_pB4zdBkf8OD4bAxC8Vr0_cmYF56uXBAZnDnXNrJNI3GRvzbL6dm49z5QfVB2h0UTG3_d-tN_q";

    $fields = array(
        'registration_ids' => $ids,
        'notification' => array(
            "title" => $title,
            "body" => $description,
        ),

    );
    $fields = json_encode($fields);
    $headers = array(
        'Authorization: key=' . $serverToken,
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);

    $result = curl_exec($ch);
    return $result;
    curl_close($ch);
}

function sendNotifTest($title, $description, $ids)
{

    $url = 'https://fcm.googleapis.com/fcm/send';
    $serverToken = "AAAA6kp-qUY:APA91bE7TvNf3RBYtWghoMAyccUbhYrV-Cbz8TsuWg5c0UaN3VcbHIxGQVHV4ZNS11_pB4zdBkf8OD4bAxC8Vr0_cmYF56uXBAZnDnXNrJNI3GRvzbL6dm49z5QfVB2h0UTG3_d-tN_q";

    $fields = array(
        'registration_ids' => $ids,
        'notification' => array(
            "title" => $title,
            "body" => $description,
        ),
        'data' => array(
            "action" => "browser", // "browser" or "page"
            "link" => "https://www.mintapp.ir/",
            "pageId" => "", // "PageCycle" or "PageQuestion" or "PageWeblog" or "PageCycle" or "PageHome"
            "pageP0" => "",
            "pageP1" => "",
            "pageP2" => "",
            "pageP3" => "",
            "pageP4" => "",
            "pageP5" => "",
            "pageP6" => "",
            "pageP7" => "",
            "pageP8" => "",
            "pageP9" => "",
        ),

    );
    $fields = json_encode($fields);
    $headers = array(
        'Authorization: key=' . $serverToken,
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);

    $result = curl_exec($ch);
    return $result;
    curl_close($ch);
}

function lookupSms($phone, $template, $token, $token2, $token10)
{
    $url = 'https://api.kavenegar.com/v1/332B38506C54444C344A2F64347A4A422B56796347754259564F4C6F3735556F/verify/lookup.json';
    if ($token2 == null) {
        if ($token10 == null) {
            $fields = [
                'receptor' => $phone,
                'token' => $token,
                'token2' => $token2,
                'template' => $template
            ];
        } else {
            $fields = [
                'receptor' => $phone,
                'token' => $token,
                'token10' => $token10,
                'template' => $template
            ];
        }
    } else {
        $fields = [
            'receptor' => $phone,
            'token' => $token,
            'token2' => $token2,
            'template' => $template
        ];
    }
    $fields_string = http_build_query($fields);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    $result = json_decode($result);
}

function adminSms($phone, $message)
{

    $url = 'https://api.kavenegar.com/v1/332B38506C54444C344A2F64347A4A422B56796347754259564F4C6F3735556F/sms/send.json';

    $fields = [
        'receptor' => $phone,
        'message' => $message
    ];

    $fields_string = http_build_query($fields);
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
}

function getMarketLink($market)
{
    switch ($market) {
        case "bazaar":
            return "break";
        case "google":
            return "https://play.google.com/store/apps/details?id=com.nikaat.mintapp";
        case "ios":
            return "https://sibapp.com/applications/Mint";
        default:
            return "https://play.google.com/store/apps/details?id=com.nikaat.mintapp";
    }
}

function getUserType($userPhone)
{
    $coach_list = array("989125354826");
    $doctor_list = array("989184745464");
    $admin_list = array("989356292212");
    $userType = "user";
    if (in_array($userPhone, $coach_list)) {
        $userType = 'coach';
    } else if (in_array($userPhone, $admin_list)) {
        $userType = 'admin';
    } else if (in_array($userPhone, $doctor_list)) {
        $userType = 'doctor';
    }
    return $userType;
}

function getOldMealName($newMealName)
{
    switch ($newMealName) {
        case "breakfast":
            return "break";
        case "snackFt":
            return "snack1";
        case "lunch":
            return "lunch";
        case "snackSd":
            return "snack2";
        case "dinner":
            return "dinner";
        case "snackTd":
            return "snack3";
        default:
            return $newMealName;
    }
}

function getSmallNameOfWeek($completeName)
{
    switch ($completeName) {
        case "saturday":
            return "sat";
        case "sunday":
            return "sun";
        case "monday":
            return "mon";
        case "tuesday":
            return "tue";
        case "wednesday":
            return "wed";
        case "thursday":
            return "thu";
        case "friday":
            return "fri";
    }
}

function getPlanDate($timestamp)
{

    $day = tsToShamsiDay($timestamp);
    $month = tsToShamsiMonth($timestamp);
    $monthName = jdate_words(array("mm" => $month));
    $dayNumber = jdate_words(array("rr" => $day));
    return $dayNumber[rr] . " " . $monthName[mm];
}

function getPersonaFromWidget($buyCase)
{

    switch ($buyCase) {

        case "babyCheck":
            return "prevent";
            break;

        case "4prevent":
            return "prevent";
            break;

        case "fitness":
            return "fitness";
            break;

        case "nutrition":
            return "fitness";
            break;

        case "pregRegime":
            return "pregnant";
            break;

        case "roadToPregnant":
            return "prepregnant";
            break;

        default:
            return "";
            break;
    }
}


function checkMeal($timestamp)
{

    $meal = null;
    $hour = jdate('H', $timestamp);
    $minute = jdate('i', $timestamp);
    if ($hour >= 0 and $hour <= 10) {
        $meal = "break";
    }
    if ($hour > 10 and $hour <= 12) {
        $meal = "snack1";
    }
    if ($hour > 12 and $hour <= 15) {
        if ($minute >= 0 and $minute <= 30) {
            $meal = "lunch";
        } else {
            $meal = "snack2";
        }
    }
    if ($hour > 15 and $hour <= 18) {
        $meal = "snack2";
    }
    if ($hour >= 19 and $hour <= 23) {
        $meal = "dinner";
    }
    return $meal;
}

function phoneFormatter($phone)
{

    $phone = trim($phone, " ");

    if (substr($phone, 0, 2) == 'gg' or substr($phone, 0, 2) == 'fb') {
        $phone = $phone;
    } else {
        preg_replace('/[^0-9]/', '', $phone);
        if (substr($phone, 0, 1) === '0') {

            $phone = '98' . substr($phone, 1);
        } else if (substr($phone, 0, 1) === '+') {

            $phone = substr($phone, 1);
        } else {
            if (strlen($phone) != 12) {
                $phone = '98' . $phone;
            }
        }
    }

    return $phone;
}

function getUserIpAddr()
{
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        //ip from share internet
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        //ip pass from proxy
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

function monthAndDayFormatter($date)
{
    if (strlen($date) == 1) {
        $date = "0" . $date;
    }
    return $date;
}

function deleteZeroFromNumber($date)
{
    if (strlen($date) > 1) {
        if (substr($date, 0, 1) == "0") {
            $date = substr($date, 1);
        }
    }
    return $date;
}

function dateFormatter($birthDate)
{
    $firstPart = substr($birthDate, 0, 4);
    $secondPart = substr($birthDate, 4, 2);
    $thirdPart = substr($birthDate, 6, 2);
    $birthDate = $firstPart . "/" . $secondPart . "/" . $thirdPart;
    return $birthDate;
}

function dateToShamsi($date)
{

    $date = strtotime($date);
    $shamsi = jdate('Y/m/d H:i:s', $date);
    $shamsi = str_replace(" ", "T", $shamsi);
    $shamsi = str_replace("/", "-", $shamsi);
    return convertPersianToEnglish($shamsi);
}

function tsToShamsi($timestamp)
{

    $shamsi = jdate('Y/m/d H:i:s', $timestamp);
    $shamsi = str_replace(" ", "T", $shamsi);
    $shamsi = str_replace("/", "-", $shamsi);
    return convertPersianToEnglish($shamsi);
}

function tsToShamsiFormated($timestamp)
{

    $shamsi_y = jdate('Y', $timestamp);
    $shamsi_m = jdate('m', $timestamp);
    $shamsi_d = jdate('d', $timestamp);
    return convertPersianToEnglish($shamsi_y . "Y" . $shamsi_m . "M" . $shamsi_d . "D");
}

function tsToShamsiYear($timestamp)
{

    $shamsi_y = jdate('Y', $timestamp);
    return convertPersianToEnglish($shamsi_y);
}

function tsToShamsiMonth($timestamp)
{

    $shamsi_m = jdate('m', $timestamp);
    return convertPersianToEnglish($shamsi_m);
}

function tsToShamsiDay($timestamp)
{

    $shamsi_d = jdate('d', $timestamp);
    return convertPersianToEnglish($shamsi_d);
}

function shamsiToTs($year, $month, $day)
{
    return jmktime("12", "0", "0", $month, $day, $year);
}

function currentTsToPaymentTs($timestamp)
{
    $year = tsToShamsiYear($timestamp);
    $month = tsToShamsiMonth($timestamp);
    $day = tsToShamsiDay($timestamp);

    return jmktime("0", "0", "0", $month, $day, $year);
}

function getBetween($string, $start = "", $end = "")
{
    if (strpos($string, $start)) { // required if $start not exist in $string
        $startCharCount = strpos($string, $start) + strlen($start);
        $firstSubStr = substr($string, $startCharCount, strlen($string));
        $endCharCount = strpos($firstSubStr, $end);
        if ($endCharCount == 0) {
            $endCharCount = strlen($firstSubStr);
        }
        return substr($firstSubStr, 0, $endCharCount);
    } else {
        return '';
    }
}

function convertPersianToEnglish($string)
{

    $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $arabic = ['٩', '٨', '٧', '٦', '٥', '٤', '٣', '٢', '١', '٠'];

    $num = range(0, 9);
    $convertedPersianNums = str_replace($persian, $num, $string);
    $englishNumbersOnly = str_replace($arabic, $num, $convertedPersianNums);

    return $englishNumbersOnly;
}

function generateCode($length = 8)
{

    $az = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $azr = rand(0, 51);
    $azs = substr($az, $azr, 10);
    $stamp = hash('sha256', time());
    $mt = hash('sha256', mt_rand(5, 20));
    $alpha = hash('sha256', $azs);
    $hash = str_shuffle($stamp . $mt . $alpha);
    $code = ucfirst(substr($hash, $azr, $length));
    return $code;
}
